package gov.va.vinci.dart.db.impl;

import java.util.List;

import javax.persistence.NoResultException;
import javax.persistence.Query;

import gov.va.vinci.dart.common.exception.ObjectNotFoundException;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.db.GroupDAO;
import gov.va.vinci.dart.db.util.HibernateDAO;

public class GroupDAOImpl extends HibernateDAO implements GroupDAO {

	@Override
	public Group findById(final int groupId) throws ObjectNotFoundException {
		Query q = createQuery("from Group where id=:gid");
		q.setParameter("gid", groupId);
		return (Group)q.getSingleResult();
	}

	@Override
	public Group findByName(final String name) throws ObjectNotFoundException {
		
		Query query = createQuery("from Group where name like :pname");
		query.setParameter("pname", name);
		try {
			return (Group)query.getSingleResult();
		} catch (NoResultException e) {
			throw new ObjectNotFoundException(e);
		}
	}
	
	@Override
	@SuppressWarnings("unchecked")
	public List<Group> listAll() {
		Query query = createQuery("from Group");
		return (List<Group>)query.getResultList();
	}

}
